﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucAssignPathway.ascx.cs" Inherits="ucAssignPathway" %>
<script type="text/javascript">
   
    function AriaASPWOKBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaASPWCancelBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    //holds the value of the first selected pathway
    var vFirstPWID = '';
    
    //will run when ExtJS library is first loaded.
    Ext.onReady( function (){ vFirstPWID = ''; });

    //sets the title to the first selected item and caches the 1st PWID clicked
    function fnSetDefaultTitle()
    {
        //get the checked nodes
        var checkedNodes = App.treeASPWEvents.getChecked();

        //is anything checked?
        var vhasChecked = false;
        var vCount = 0;
        Ext.each(checkedNodes,
                    function (node) 
                    {
                        //has a node checked
                        vhasChecked = true;
                        vCount++;
                    }
                 );

        //no value in text box or only 1 item selected, so set it
        if (Ext.getCmp('tfPWAPWTitle').getValue() == '' || vCount == 1)
        {
            Ext.each(checkedNodes,
                    function (node)
                    {
                        //keep the PW id of the first node selected
                        vFirstPWID = node.data.id;

                        //has a node checked
                        vhasChecked = true;

                        //set the value of the text box 
                        Ext.getCmp('tfPWAPWTitle').setValue(node.data.text);
                    });
        }
        
        //nothing checked so clear text
        if (!vhasChecked)
        {
            vFirstPWID = '';
            Ext.getCmp('tfPWAPWTitle').setValue('');
        }
    };

    //sets the title to the first selected item and caches the 1st PWID clicked
    function OnTreeNodeSelect()
    {
        var selectedNode = App.treeASPWEvents.getSelectionModel().getSelection();
        var selCheck = selectedNode[0].data.id;
        if (selCheck.indexOf("|") == -1)
        {
            vFirstPWID = selectedNode[0].data.id;

            //set the value of the text box 
            Ext.getCmp('tfPWAPWTitle').setValue(selectedNode[0].data.text);
        }
    };

    //reloads the tree
    var fnASCPAReloadTree = function (result)
    {
        if (result != -1)
        {
            App.direct.PATSUMMARY.LoadPatPWList2();
        }
    };

    //gathers the selected pathways and calls onok to apply the combined pathway
    var fnGetSelectedPathways = function () {
        //call the direct method
        App.direct.UCASPATHWAY.OnOK(vFirstPWID, {
            failure: GeneralErrorHandler
        });
    };

    var fnASPWValForm = function () {
        if (App.tfPWAPWTitle.isValid() && App.dfPWABaseline.isValid()) {
            App.btnASPWOK.setDisabled(false);
        } else {
            App.btnASPWOK.setDisabled(true);
        }
    };
</script>

<ext:Window ID="wndApplyPathway" 
    Title="Apply Pathway" Hidden="true"
    Layout="AnchorLayout" Height="515" Width="855"
     IDMode="Static" runat="server" Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
<Items>    
     <ext:FormPanel
                ID="fpnlApplypathway"
                Margin="3"
                Border="false"
                Layout="AnchorLayout"
                runat="server">
                <Items>

     <ext:Panel Border="false" ID="pnlPWtype" 
         Layout="ColumnLayout" runat="server">
     <Items>
     
         <ext:RadioGroup
            ID="rgPWtype"
            runat="server"
            Vertical="true"
             Width="175"
            LabelWidth="50" 
            Padding="2">
        
        <Items>
            <ext:Radio ID="rdoPWInpatient" BoxLabel="Inpatient" 
                Checked="true" LabelWidth="55" runat="server" ></ext:Radio>
            <ext:Radio ID="rdoPWOutpatient" BoxLabel="Outpatient"  
                LabelWidth="60"  runat="server" ></ext:Radio>
        </Items>
        <Listeners>
            <Change Handler="App.direct.UCASPATHWAY.OnPWFilter(this.getValue());" />
        </Listeners>
        </ext:RadioGroup>

     </Items>
     </ext:Panel>

     <ext:TreePanel ID="treeASPWEvents"
                        runat="server" 
                        AnchorHorizontal="99%"
                        Height="340"
                        Margin="2"
                        RootVisible="false"
                        Lines="false"
                        UseArrows="true" 
                        IDMode="Static">
    <Store>
        <ext:TreeStore IDMode="Static" ID="storASPWTree" runat="server" AutoLoad="false" >
        <Root>
        </Root>
        </ext:TreeStore>
    </Store>
    <Listeners>
        <CheckChange Handler="fnSetDefaultTitle();"></CheckChange>
        <SelectionChange  Handler="OnTreeNodeSelect();" ></SelectionChange>
    </Listeners>
    <Items>

    
    </Items>
    </ext:TreePanel>      

    <ext:Panel Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
    <Items>

    <ext:Label ID="lblPWAPWTitle" Width="130" Padding="5" Text="Pathway Title" runat="server"></ext:Label>

        <ext:TextField AutoDataBind="true"
            Padding="3" ID="tfPWAPWTitle" IDMode="Static" ReadOnly="false" Width="580" runat="server" Vtype="alphanumXSS">
            <Listeners>
                <Change Fn="fnASPWValForm" />
            </Listeners>
        </ext:TextField>
    </Items>
    </ext:Panel>

    <ext:Panel  Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
    <Items>

     <ext:Label  Width="130" Padding="5" Text="Baseline Date" runat="server"></ext:Label>

        <ext:DateField ID="dfPWABaseline"
            runat="server"
            AllowBlank="false"
            AutoDataBind="true"
            Width="100"
            Padding="5" 
            Format="MM/dd/yyyy"
            Vtype="date"
            InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
            <Listeners>
                <Change Fn="fnASPWValForm" />
            </Listeners>
        </ext:DateField>
    </Items>
    </ext:Panel>
   
    
    </Items>
    </ext:FormPanel>

</Items>
<BottomBar>
    <ext:Toolbar runat="server">
    <Items>
        <ext:Button ID="btnASPWOK" runat="server" Text="Apply Pathway" Icon="Disk" Handler="fnGetSelectedPathways()" >
            <Listeners>
                <AfterRender Handler="AriaASPWOKBtn(App.btnASPWOK.getEl());" ></AfterRender>
            </Listeners>
        </ext:Button>

        <ext:Button ID="btnASPWCancel" runat="server" Text="Cancel" Icon="Cancel" Handler="App.direct.UCASPATHWAY.OnCancel()" >
            <Listeners>
                <AfterRender Handler="AriaASPWCancelBtn(App.btnASPWCancel.getEl());" ></AfterRender>
            </Listeners>
        </ext:Button>

    </Items>
    </ext:Toolbar>
</BottomBar>
</ext:Window>
